<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Color extends Model 
{

    protected $table = 'colors';
    public $timestamps = true;
    protected $fillable = array('code', 'name', 'product_id');

    public function medias()
    {
        return $this->morphMany('App\Models\Media', 'mediaable');
    }

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

}